      SUBROUTINE DBP (N,B,X)
C***BEGIN PROLOGUE  DBP
C***DESCRIPTION
C    From the book "Numerical Methods and Software"
C       by D. Kahaner, C. Moler, S. Nash
C          Prentice Hall 1988
C
C    Abstract
C       Computes values (at X) of the N+1 Bernstein basis functions 
C         of degree N on [0,1]
C
C    Description of Parameters
C       Input:  N (integer)           .GE. 0
C               X (double precision)  Abscissa for evaluation of polynomials
C       Output: B(0:N) (double precision array)
C                       B(I)= N!/(I!*(N-I)!) * (1.-X)**(N-I) * X**I
C                                       I=0,1,...,N
C***END PROLOGUE  DBP
C
      INTEGER  N,C,R
      DOUBLE PRECISION B(0:N),X
C
      IF (N .EQ. 0) THEN
        B(0) = 1.0D0
      ELSE IF (N .GT. 0) THEN
        DO 2 C=1,N
           IF (C .EQ. 1) THEN
                B(1) = X
           ELSE
                B(C) = X*B(C-1)
           END IF
C
           DO 1 R=C-1,1,-1
                B(R) = X*B(R-1) + (1.0D0-X)*B(R)
    1      CONTINUE
C
           IF (C .EQ. 1) THEN
                B(0) = 1.0D0-X
           ELSE
                B(0) = (1.0D0-X)*B(0)
           END IF
    2   CONTINUE
      END IF
      RETURN
      END
